% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates_and_times.R
\name{df_continuous}
\alias{df_continuous}
\title{Check if a dataframe is continuous}
\usage{
df_continuous(df, time_var = "Timestamp", digits = 6, ...)
}
\arguments{
\item{df}{the input data frame}

\item{time_var}{character scalar giving the column name of the variable
containing timestamp information (either \code{character} or \code{POSIXt}
format)}

\item{digits}{see \code{\link{epoch_length_sec}}}

\item{...}{arguments passed to \code{as.POSIXct}, for use if \code{time_var}
is a character rather than \code{POSIXt} variable}
}
\description{
Check if a dataframe is continuous
}
\examples{
data(ex_data, package = "PAutilities")
df_continuous(ex_data, "DateTime", tz = "UTC")
df_continuous(ex_data[-c(300:500), ], "DateTime", tz = "UTC")
}
