% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readLocalAIS.R
\name{readLocalAIS}
\alias{readLocalAIS}
\title{Read AIS Data Near GPS Track}
\usage{
readLocalAIS(gps, aisDir, distance = 10000, timeBuff = 0)
}
\arguments{
\item{gps}{a dataframe with columns \code{UTC}, \code{Latitude},
and \code{Longitude} to get nearby AIS data for}

\item{aisDir}{directory of AIS CSV files to read from}

\item{distance}{distance in meters around the GPS track to read AIS
data for}

\item{timeBuff}{extra time (seconds) before and after the GPS points
to read AIS data for. This can help create a better picture of ship
activity surrounding the GPS}
}
\value{
a dataframe of AIS data, with additional columns related to distance
to provided buoy GPS track
}
\description{
Reads in AIS data downloaded from Marine Cadastre of
ship tracks that come within a certain distance of a given GPS
track. Also calculates the distance to the GPS track for each
AIS point
}
\examples{
gps <- data.frame(Latitude=c(33.2, 33.5,33.6),
                  Longitude=c(-118.1, -118.4, -119),
                  UTC=as.POSIXct(
                    c('2022-04-28 05:00:00',
                      '2022-04-28 10:00:00',
                      '2022-04-28 20:00:00'),
                    tz='UTC'))
ais <- readLocalAIS(gps, aisDir=system.file('extdata/ais', package='PAMscapes'), distance=20e3)
str(ais)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
