% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createOctaveLevel.R
\name{createOctaveLevel}
\alias{createOctaveLevel}
\title{Create Octave Level Measurements}
\usage{
createOctaveLevel(
  x,
  type = c("ol", "tol"),
  freqRange = NULL,
  normalized = FALSE
)
}
\arguments{
\item{x}{dataframe of soundscape metrics}

\item{type}{either \code{'ol'} to create octave level or \code{'tol'} to create
third octave level measures}

\item{freqRange}{a vector of the minimum and maximum center frequencies (Hz) desired
for the output. If \code{NULL}, full available range of frequencies will be used.}

\item{normalized}{logical flag to return values normalized by the bandwidth of
each octave level band}
}
\value{
a dataframe with summarised octave level band measurements
}
\description{
Creates octave or third octave level measurements from finer
resolution soundscape metrics, like Power Spectral Density (PSD) or
Hybrid Millidecade (HMD) measures
}
\details{
Note that these measures are not as precise as they could be, mostly
meant to be used for visualizations. Bands of the original data that do not
fit entirely within a single octave band are not proportionately split between
the two proper output bands. Instead an output band will contain all inputs where
the center frequency falls between the limits of the output band. For higher
frequencies this should result in negligible differences, but lower frequencies
will be more imprecise.
}
\examples{
psd <- loadSoundscapeData(system.file('extdata/PSDSmall.csv', package='PAMscapes'))
str(psd)
tol <- createOctaveLevel(psd, type='tol')
str(tol)
ol <- createOctaveLevel(tol, type='ol')
str(ol)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
