% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeAMWave.R
\name{writeAMWave}
\alias{writeAMWave}
\alias{createAMWave}
\title{Write Amplitude Modulated Waveform}
\usage{
writeAMWave(
  fileName,
  outDir,
  signalLength,
  modFrequency,
  frequency,
  sampleRate,
  window = c(0.55, 0.45),
  silence = c(0, 0),
  gainFactor = 0.1
)

createAMWave(
  signalLength,
  modFrequency,
  frequency,
  sampleRate,
  window = c(0.55, 0.45),
  silence = c(0, 0),
  gainFactor = 0.1
)
}
\arguments{
\item{fileName}{name of the file to write. If missing, the file be named
usign signalLength, modFrequency, frequency, and sampleRate}

\item{outDir}{directory to write wave files to}

\item{signalLength}{length of signal to create in seconds}

\item{modFrequency}{modulation frequency in Hz of the amplitude modulation}

\item{frequency}{frequency of the AM call}

\item{sampleRate}{sample rate for the wave file to create}

\item{window}{window constants for applying the amplitude modulation. See details.}

\item{silence}{silence to pad before and after signal in seconds}

\item{gainFactor}{scaling factor between 0 and 1. Low numbers are recommended (default 0.1)}
}
\value{
\code{writeAMWave} invisibly returns the file name, \code{createAMWave}
  returns a \linkS4class{Wave} class object
}
\description{
Write a wave file for a synthesized amplitude modulated call
}
\details{
Amplitude modulated signals are modelled as an ideal sinusoid multiplied by a
  window function. The window function is an offset sinusoid with frequency equal to the
  modulation frequency:
 \deqn{W = .5 + .45 * sin(2 \pi mf t)}
 See \code{example(writeAMWave)} for a plot showing how this works.
}
\examples{

# Visualisation of modelled AM wave
signal <- sin(2*pi*100*(1:1000)/1000)
window <- .55 + .45 * sin(2*pi*15*(1:1000)/1000)
oldMf <- par()$mfrow
par(mfrow=c(3,1))
plot(signal, type='l')
plot(window, type='l')
plot(window*signal, type='l')
tmpFile <- file.path(tempdir(), 'tempWav.wav')
writeAMWave(tmpFile, signalLength = 1, modFrequency = 1000,
               frequency = 30000, sampleRate = 100000)
file.remove(tmpFile)
amWave <- createAMWave(signalLength = 1, modFrequency = 1000,
                             frequency = 30e3, sampleRate = 100e3)
par(mfrow=oldMf)
}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
