% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPresBar.R
\name{plotPresBar}
\alias{plotPresBar}
\title{plotPresBar}
\usage{
plotPresBar(
  x,
  start = NULL,
  end = NULL,
  timeBin = c("day", "week", "month", "hour"),
  type = c("presence", "density"),
  presBin = c("hour", "day", "week", "minute"),
  by = NULL,
  title = TRUE,
  fill = "grey35",
  format = c("\%m/\%d/\%Y \%H:\%M:\%S", "\%m-\%d-\%Y \%H:\%M:\%S",
    "\%Y/\%m/\%d \%H:\%M:\%S", "\%Y-\%m-\%d \%H:\%M:\%S")
)
}
\arguments{
\item{x}{a data.frame of detections, must have a column \code{UTC} that contains the
time of detection as a POSIXct object in UTC timezone}

\item{start}{the beginning datetime of the plot, if \code{NULL} will be set to the minimum
time in \code{x}}

\item{end}{the ending datetime of the plot, if \code{NULL} will be set to the maximum
time in \code{x}}

\item{timeBin}{the unit of time for each bar in the plot, must be one of "hour", "day",
"week", or "month"}

\item{type}{one of either "presence" or "density". If "density", then the total number of
detections in each \code{timeBin} will be plotted. If "presence", then you must also set
\code{presBin} to define the time scale for binning detections}

\item{presBin}{one of either "hour", "day", "week", or "minute", and must be a smaller unit
of time than \code{timeBin}. This defines the timescale for counting presence. For example,
\code{timeBin} of "day" and \code{presBin} of "hour" will plot the number of hours in each day
that have detections.}

\item{by}{(optional) if not \code{NULL}, specifies the name of a column in \code{x} to split and
color the bars by}

\item{title}{if \code{TRUE}, a title will automatically created. If any other value, that will be
used for the title of the plot.}

\item{fill}{the fill color for the bars, only used if \code{by} is \code{NULL}, otherwise bars are
colored by species using the default \link{ggplot2} palette}

\item{format}{date format if \code{UTC} column of \code{x} is a character}
}
\value{
a ggplot2 object
}
\description{
Creates a bar plot of the presence or density of detections across time
}
\examples{

df <- data.frame(UTC = as.POSIXct(runif(1e2, min=0, max=7*24*3600),
                                  origin='1970-01-01 00:00:00', tz='UTC'),
                 label = sample(letters[1:3], 1e3, replace=TRUE))
plotPresBar(df, type='presence', timeBin='day', presBin='hour')
plotPresBar(df, type='density', timeBin='day')
plotPresBar(df, type='density', timeBin='day', by='label')

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
