% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variancefeaturePlot.R
\name{variancefeaturePlot}
\alias{variancefeaturePlot}
\title{variancefeaturePlot Function}
\usage{
variancefeaturePlot(
  data_object = NULL,
  vardata = NULL,
  featureSet = "PTID",
  Residual = FALSE,
  top_n = 15,
  cols = NULL,
  ncol = NULL
)
}
\arguments{
\item{data_object}{Input \emph{PALMO} S4 object. It contains annotation
information
and expression data from Bulk or single cell data.}

\item{vardata}{Variance result obtained from lmeVariance function}

\item{featureSet}{Column of interest to focus on, Default is 'PTID'}

\item{Residual}{Add residual in plot, Default FALSE}

\item{top_n}{Number of top features to show. Default is 10.}

\item{cols}{The colors associated with features. Default is NULL.}

\item{ncol}{Plot_grid number of plot columns.}
}
\value{
variance plot list
}
\description{
This function allows user to plot variance observed in the data by provided
featureList
}
\examples{
\dontrun{
variancefeaturePlot(data_object=palmo_obj, top_n=15)
}
}
\keyword{variancefeaturePlot}
