% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stayTimes.R
\name{getSiteStayTimes}
\alias{getSiteStayTimes}
\title{Calculate estimated stay times for locations given isotopic values}
\usage{
getSiteStayTimes(object, siteMeans, siteSigma, intervalLengths = NULL,
  print = TRUE)
}
\arguments{
\item{object}{model of class \code{\link{TemporalIso}}}

\item{siteMeans}{numeric vector. Isotopic mean values of sites/locations.}

\item{siteSigma}{numeric vector. Isotopic standard deviation values of sites/locations..}

\item{intervalLengths}{numceric vector. Vector of time interval lengths. Optional (if not given equal length intervals are assumed)}

\item{print}{boolean. If output should be printed. Defaults to TRUE.}
}
\value{
a data.frame containing the interval starts (intStart) and ends (intEnd) of changes.
}
\description{
The function calculates points in time where large changes happen in the isotopic values. It uses the posterior
distributions to estimate the probability of changes to be (absolutely or relatively) large.
}
