% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_optM.R
\name{plot_optM}
\alias{plot_optM}
\title{plot_optM function}
\usage{
plot_optM(input, method = "Evanno", plot = TRUE, pdf = NULL)
}
\arguments{
\item{input}{an object produced by the fucntion 'optM'}

\item{method}{a string containing the method to use, either "Evanno", "linear", or "SiZer".  Default is "Evanno", but needs to match that used in 'optM'}

\item{plot}{logical of whether or not to display the plot}

\item{pdf}{string of the file name to save the resulting pdf plot.  If NULL, no file is saved.  Default is NULL}
}
\value{
a plot or pdf of a plot
}
\description{
Plotting the optM results.
This function visualizes the output of optM, including the amount of total variation
explained across each value of the migration rate
}
\examples{
# Load a folder of simulated test data for m = 3
folder <- system.file("extdata", package = "OptM")
# Run the Evanno method and plot the results
test.optM = optM(folder)
plot_optM(test.optM, method = "Evanno")

# To view the various linear modeling estimates and plot:
   # test.linear = optM(folder, method = "linear")
   # plot_optM(test.linear, method = "linear")

# To view the results from the SiZer package:
   # test.sizer = optM(folder, method = "SiZer")
   # plot_optM(test.sizer, method = "SiZer")
}
\keyword{plot_optM}
