/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.io.IOException;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractOsmTileSource;

public class OsmTileSource {
    public static final String MAP_MAPNIK = "http://tile.openstreetmap.org";
    public static final String MAP_OSMA = "http://tah.openstreetmap.org/Tiles";
    public static String cloudMadeKey = "c94706833793432e93b3a9cd9e0cce52";

    public static class Apple
    extends AbstractOsmTileSource {
        public Apple() {
            super("apple-iphoto", "");
        }

        public String getTilePath(int zoom, int tilex, int tiley) throws IOException {
            return "http://gsp2.apple.com/tile?api=1&style=slideshow&layers=default&lang=en_EN&z=" + zoom + "&x=" + tilex + "&y=" + tiley + "&v=9";
        }

        public String getTileType() {
            return "jpeg";
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "\u00ac\u00a9 Apple with data from OpenStreetMap";
        }

        public String getAttributionLinkURL() {
            return "http://apple.com";
        }

        public String getTermsOfUseURL() {
            return "http://apple.com";
        }
    }

    public static class BBBike
    extends AbstractOsmTileSource {
        public BBBike() {
            super("osm-bbike", "http://a.tile.bbbike.org/osm/mapnik");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "\u00ac\u00a9 OpenStreetMap contributors, CC-BY-SA ";
        }

        public String getAttributionLinkURL() {
            return "http://openstreetmap.org/";
        }

        public String getTermsOfUseURL() {
            return "http://www.openstreetmap.org/copyright";
        }
    }

    public static class BBBikeGerman
    extends AbstractOsmTileSource {
        public BBBikeGerman() {
            super("osm-bbike-german", "http://a.tile.bbbike.org/osm/mapnik-german");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "\u00ac\u00a9 OpenStreetMap contributors, CC-BY-SA ";
        }

        public String getAttributionLinkURL() {
            return "http://openstreetmap.org/";
        }

        public String getTermsOfUseURL() {
            return "http://www.openstreetmap.org/copyright";
        }
    }

    public static class CloudMade
    extends AbstractOsmTileSource {
        public String mapId;

        public CloudMade(String id) {
            super("cloudmade-" + id, "");
            this.mapId = id;
        }

        public String getTilePath(int zoom, int tilex, int tiley) throws IOException {
            return "http://a.tile.cloudmade.com/" + cloudMadeKey + "/" + this.mapId + "/256/" + zoom + "/" + tilex + "/" + tiley + "." + this.getExtension();
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "\u00ac\u00a9 OpenStreetMap contributors with CloudMade.com, CC-BY-SA";
        }

        public String getAttributionLinkURL() {
            return "http://www.cloudmade.com";
        }

        public String getTermsOfUseURL() {
            return "http://cloudmade.com/website-terms-conditions";
        }
    }

    public static class CycleMap
    extends AbstractOsmTileSource {
        private static final String PATTERN = "http://%s.tile.opencyclemap.org/cycle";
        private static final String[] SERVER = new String[]{"a", "b", "c"};
        private int SERVER_NUM = 0;

        public CycleMap() {
            super("opencyclemap", PATTERN);
        }

        public String getBaseUrl() {
            String url = String.format(this.baseUrl, SERVER[this.SERVER_NUM]);
            this.SERVER_NUM = (this.SERVER_NUM + 1) % SERVER.length;
            return url;
        }

        public int getMaxZoom() {
            return 17;
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.LastModified;
        }
    }

    public static class Esri
    extends AbstractOsmTileSource {
        public Esri() {
            super("esri", "http://server.arcgisonline.com/ArcGIS/rest/services/World_Street_Map/MapServer/tile");
        }

        public String getTileType() {
            return "jpg";
        }

        public String getExtension() {
            return "jpg";
        }

        public String getTilePath(int zoom, int tilex, int tiley) throws IOException {
            return "/" + zoom + "/" + tiley + "/" + tilex + "." + this.getExtension();
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.None;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "\u00ac\u00a9 ESRI";
        }

        public String getAttributionLinkURL() {
            return "http://services.arcgisonline.com/ArcGIS/rest/services/ESRI_Imagery_World_2D/MapServer";
        }

        public String getTermsOfUseURL() {
            return "http://services.arcgisonline.com/ArcGIS/rest/services/ESRI_Imagery_World_2D/MapServer";
        }
    }

    public static class EsriTopo
    extends AbstractOsmTileSource {
        public EsriTopo() {
            super("esri-topo", "http://services.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer/tile");
        }

        public String getTileType() {
            return "jpg";
        }

        public String getExtension() {
            return "jpg";
        }

        public String getTilePath(int zoom, int tilex, int tiley) throws IOException {
            return "/" + zoom + "/" + tiley + "/" + tilex + "." + this.getExtension();
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.None;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "\u00ac\u00a9 ESRI";
        }

        public String getAttributionLinkURL() {
            return "http://services.arcgisonline.com/ArcGIS/rest/services/ESRI_Imagery_World_2D/MapServer";
        }

        public String getTermsOfUseURL() {
            return "http://services.arcgisonline.com/ArcGIS/rest/services/ESRI_Imagery_World_2D/MapServer";
        }
    }

    public static class HillShade
    extends AbstractOsmTileSource {
        public HillShade() {
            super("hillshade", "http://toolserver.org/~cmarqu/hill");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "\u00ac\u00a9 OpenStreetMap contributors, CC-BY-SA and http://toolserver.org/~cmarqu/";
        }

        public String getAttributionLinkURL() {
            return "http://toolserver.org/~cmarqu/";
        }

        public String getTermsOfUseURL() {
            return "http://toolserver.org/~cmarqu/";
        }
    }

    public static class MapBox
    extends AbstractOsmTileSource {
        public MapBox() {
            super("mapbox", "http://a.tiles.mapbox.com/v3/examples.map-vyofok3q");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "\u00ac\u00a9 OpenStreetMap contributors and mapbox.com, CC-BY-SA ";
        }

        public String getAttributionLinkURL() {
            return "http://mapbox.com/";
        }

        public String getTermsOfUseURL() {
            return "http://mapbox.com";
        }
    }

    public static class MapToolKitTopo
    extends AbstractOsmTileSource {
        public MapToolKitTopo() {
            super("maptoolkit-topo", "http://tile1.maptoolkit.net/terrain");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "www.maptoolkit.net";
        }

        public String getAttributionLinkURL() {
            return "http://maptoolkit.net/";
        }

        public String getTermsOfUseURL() {
            return "http://www.maptoolkit.net";
        }
    }

    public static class Mapnik
    extends AbstractOsmTileSource {
        public Mapnik() {
            super("osm", OsmTileSource.MAP_MAPNIK);
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }
    }

    public static class MapnikBw
    extends AbstractOsmTileSource {
        public MapnikBw() {
            super("osm-bw", "http://a.www.toolserver.org/tiles/bw-mapnik");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }
    }

    public static class MapnikGerman
    extends AbstractOsmTileSource {
        public MapnikGerman() {
            super("osm-german", "http://tile.openstreetmap.de/tiles/osmde");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }
    }

    public static class Nps
    extends AbstractOsmTileSource {
        public Nps() {
            super("nps", "http://services.arcgisonline.com/ArcGIS/rest/services/World_Physical_Map/MapServer/tile");
        }

        public String getTileType() {
            return "jpg";
        }

        public String getTilePath(int zoom, int tilex, int tiley) throws IOException {
            return "/" + zoom + "/" + tiley + "/" + tilex + "." + this.getExtension();
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "\u00ac\u00a9 National Park Service";
        }

        public String getAttributionLinkURL() {
            return "http://goto.arcgisonline.com/maps/World_Physical_Map";
        }

        public String getTermsOfUseURL() {
            return "http://goto.arcgisonline.com/maps/World_Physical_Map";
        }
    }

    public static class OSM2World
    extends AbstractOsmTileSource {
        public OSM2World() {
            super("osm2world-3d", "http://c.tiles.osm2world.org/osm/pngtiles/n");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "";
        }

        public String getAttributionLinkURL() {
            return "http://osm2world.org/";
        }

        public String getTermsOfUseURL() {
            return "http://osm2world.org/";
        }
    }

    public static abstract class OsmaSource
    extends AbstractOsmTileSource {
        String osmaSuffix;

        public OsmaSource(String name, String osmaSuffix) {
            super(name, OsmTileSource.MAP_OSMA);
            this.osmaSuffix = osmaSuffix;
        }

        public int getMaxZoom() {
            return 17;
        }

        public String getBaseUrl() {
            return "http://tah.openstreetmap.org/Tiles/" + this.osmaSuffix;
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfModifiedSince;
        }
    }

    public static class PublicTransport
    extends AbstractOsmTileSource {
        public PublicTransport() {
            super("osm-public-transport", "http://tile.memomaps.de/tilegen");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "\u00ac\u00a9 OpenStreetMap contributors, CC-BY-SA ";
        }

        public String getAttributionLinkURL() {
            return "http://openstreetmap.org/";
        }

        public String getTermsOfUseURL() {
            return "http://www.openstreetmap.org/copyright";
        }
    }

    public static class Skobbler
    extends AbstractOsmTileSource {
        public Skobbler() {
            super("skobbler", "http://tiles1.skobbler.net/osm_tiles2");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "\u00ac\u00a9 OpenStreetMap contributors and skobbler.com, CC-BY-SA ";
        }

        public String getAttributionLinkURL() {
            return "http://skobbler.com";
        }

        public String getTermsOfUseURL() {
            return "http://skobbler.com";
        }
    }

    public static class Transport
    extends AbstractOsmTileSource {
        public Transport() {
            super("osm-transport", "http://a.tile2.opencyclemap.org/transport");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "\u00ac\u00a9 OpenStreetMap contributors, CC-BY-SA ";
        }

        public String getAttributionLinkURL() {
            return "http://openstreetmap.org/";
        }

        public String getTermsOfUseURL() {
            return "http://www.openstreetmap.org/copyright";
        }
    }

    public static class Wanderreitkarte
    extends AbstractOsmTileSource {
        public Wanderreitkarte() {
            super("osm-wanderreitkarte", "http://www.wanderreitkarte.de/topo");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "\u00ac\u00a9 OpenStreetMap contributors and http://www.wanderreitkarte.de, CC-BY-SA ";
        }

        public String getAttributionLinkURL() {
            return "http://www.wanderreitkarte.de/";
        }

        public String getTermsOfUseURL() {
            return "http://www.wanderreitkarte.de/licence_de.php";
        }
    }

    public static class Waze
    extends AbstractOsmTileSource {
        public Waze() {
            super("waze", "http://tiles1.waze.com/tiles");
        }

        public TileSource.TileUpdate getTileUpdate() {
            return TileSource.TileUpdate.IfNoneMatch;
        }

        public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
            return "www.waze.com";
        }

        public String getAttributionLinkURL() {
            return "http://waze.com";
        }

        public String getTermsOfUseURL() {
            return "http://www.waze.com/legal/tos/";
        }
    }
}

