% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perturbate.R
\name{perturbate}
\alias{perturbate}
\alias{grids_perturbate}
\title{Perturbate grid ratings}
\usage{
perturbate(x, prop = 0.1, amount = c(-1, 1), prob = c(0.5, 0.5))

grids_perturbate(x, n = 10, prop = 0.1, amount = c(-1, 1), prob = c(0.5, 0.5))
}
\arguments{
\item{x}{A \code{repgrid} object.}

\item{prop}{The proportion of ratings to be perturbated.}

\item{amount}{The amount set of possible perturbations. Will depend on scale
range. Usually {-1, 1} are reasonable settings}

\item{prob}{Probability for each amount to occur.}

\item{n}{Number of perturbated grid to generate.}
}
\description{
Randomly subtract or add an amount to a proportion of the grid ratings. This
emulates randomness during the rating process, producing a grid which might
also have resulted.
}
\examples{
## All results for PVAFF index when ratings are slightly perturbated
p <- indexPvaff(boeker)
l <- grids_perturbate(boeker, n = 100, prop = .1)
pp <- sapply(l, indexPvaff)  # apply indexPvaff function to all perturbated grids
range(pp)   # min and max PVAFF
hist(pp, xlab = "PVAFF values")    # visualize
abline(v = p, col = "blue", lty = 2)
}
