% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.r
\name{indexPolarization}
\alias{indexPolarization}
\title{Polarization (percentage of extreme ratings)}
\usage{
indexPolarization(x, deviation = 0)
}
\arguments{
\item{x}{A \code{repgrid} object.}

\item{deviation}{The maximal deviation from the end of the rating scale for
values to be considered an 'extreme' rating. By default only values that
lie directly on ends of the ratings scales are considered 'extreme'
(default = \code{0}).}
}
\value{
List of class \code{indexPolarization}:
\itemize{
\item \code{scale}: Minimum and maximum of grid rating scale.
\item \verb{lower,upper} Lower and upper value to decide which ratings are considered extreme.
\item \code{polarization_total}: Grid's overall polarization.
\item \code{polarization_constructs}: Polarization per construct.
\item \code{polarization_elements}: Polarization per element.
}
}
\description{
Polarization is the percentage of extreme ratings, e.g. the values 1 and 7
for a grid with a 7-point ratings scale.
}
\examples{
p <- indexPolarization(boeker)
p

# control the output
print(p, output = "T")  # total polarization
print(p, output = "C")  # construct polarization
print(p, output = "E")  # element polarization
}
