% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.r
\name{importScivescoInternal}
\alias{importScivescoInternal}
\title{Internal parser for sci:vesco files (suffix \code{scires}).}
\usage{
importScivescoInternal(file, dir = NULL)
}
\arguments{
\item{file}{filename including path if file is not in current working 
directory. File can also be a complete URL. The fileformat
is .dat.}

\item{dir}{alternative way to supply the directory where the file is located 
(default \code{NULL}).}
}
\value{
a list with extracted parameters.
}
\description{
Internal parser for sci:vesco files (suffix \code{scires}).
}
\note{
Sci:Vesco offers the options to rate the construct poles seperately or using
               a bipolar scale. The seperated rating is done using the "tetralemma" field.
               The field is a bivariate plane on which each of the four (tetra) corners  
               has a different meaning in terms of rating. Using this approach also allows ratings
               like: "both poles apply", "none of the poles apply" and all intermediate ratings
               can be chosen. This relaxes the bipolarity assumption often assumed in grid theory and
               allows for deviation from a strict bipolar rating if the constructs are not applied
               in a bipolar way. Using the tetralemma field for rating requires to analyze
               each construct seperately though. This means we get a double entry grid where the 
               emergent and constrast pole ratings might not simply be a reflection of on another.
               If a tetralemma field has been used for rating, \code{OpenRepGrid} offers the option 
               to transform the scores into "normal" grid ratings (i.e. restricted to bipolarity)
               by projecting the ratings from the bivariate tetralemma field onto the diagonal 
               of the tetralemma field and thus forcing a bipolar rating type. This option is 
               not recommended due to the fact that the conversion is susceptible to error
               when both ratings are near to zero.

TODO: The element IDs are not used yet. This might cause wrong assignments.
}
\examples{
\dontrun{

# supposing that the data file scivesco.scires is in the current directory
file <- "scivesco.scires"
imp <- importScivescoInternal(file)

# specifying a directory (arbitrary example directory)
dir <- "/Users/markheckmann/data"
imp <- importScivescoInternal(file, dir)

# using a full path
imp <- importScivescoInternal("/Users/markheckmann/data/scivesco.scires")

# load Sci:Vesco data from URL
imp <- importScivescoInternal("http://www.openrepgrid.uni-bremen.de/data/scivesco.scires")
}


}
\author{
Mark Heckmann
}
\keyword{internal}
