% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MxPPML.R
\name{imxPPML.Test.Battery}
\alias{imxPPML.Test.Battery}
\title{imxPPML.Test.Battery}
\usage{
imxPPML.Test.Battery(model, verbose = FALSE, testMissingness = TRUE,
  testPermutations = TRUE, testEstimates = TRUE, testFakeLatents = TRUE,
  tolerances = c(0.001, 0.001, 0.001))
}
\arguments{
\item{model}{the model to test}

\item{verbose}{whether to print diagnostics}

\item{testMissingness}{try with missingness}

\item{testPermutations}{try with permutations}

\item{testEstimates}{examine estimates}

\item{testFakeLatents}{try with fake latents}

\item{tolerances}{a vector of tolerances}
}
\description{
PPML can be applied to a number of special cases.  This function will test the given model for
all of these special cases.
}
\details{
Requirements for model passed to this function:
- Path-specified
- Means vector must be present
- Covariance data (with data means vector)
- (Recommended) All error variances should be specified on the
diagonal of the S matrix, and not as a latent with a loading only
on to that manifest

Function will test across all permutations of:
- Covariance vs Raw data
- Means vector present vs Means vector absent
- Path versus Matrix specification
- All orders of permutations of latents with manifests
}

