% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadOMLObject.R
\name{downloadOMLObject}
\alias{downloadOMLObject}
\title{Download an OpenML Object.}
\usage{
downloadOMLObject(id, object = c("data", "task", "flow", "run"),
  overwrite = FALSE, cache.only = FALSE, verbosity = NULL)
}
\arguments{
\item{id}{[\code{integer(1)}]\cr
The ID of the OpenML Object.}

\item{object}{[\code{character(1)}]\cr
The data, task, flow or run that should be downloaded.
Default is none.}

\item{overwrite}{[\code{logical(1)}]\cr
Should files that are already in cache be overwritten?
Default is \code{FALSE}.}

\item{cache.only}{[\code{logical(1)}]\cr
Only try to retrieve the object from cache.
Will result in error if the object is not found.
Default is \code{FALSE}.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\value{
[list]
}
\description{
Download all files that refer to data, task, flow or run and
returns the corresponding parsed XML.
}
\keyword{internal}
