% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uploadOMLDataSet.R
\name{uploadOMLDataSet}
\alias{uploadOMLDataSet}
\title{Upload a data set to the OpenML server.}
\usage{
uploadOMLDataSet(x, tags = NULL, description = NULL,
  confirm.upload = NULL, verbosity = NULL)
}
\arguments{
\item{x}{[\code{\link[mlr]{Task}}|[\code{\link{OMLDataSet}}]\cr
Contains the data set that should be uploaded.}

\item{tags}{[\code{character}]\cr
The tags that should be added after uploading.}

\item{description}{[\code{character(1)}|\code{\link{OMLDataSetDescription}}]\cr
Either an \code{\link{OMLDataSetDescription}} or a \code{character(1)} that describes the data. 
For the latter, all other relevant information is autogenerated from the \code{\link[mlr]{Task}}.}

\item{confirm.upload}{[\code{logical(1)}]\cr
Should the user be asked to confirm the upload?
Default is the setting from your config.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\value{
[\code{invisible(numeric(1))}].
  The ID of the data (\code{data.id}).
}
\description{
Share a data set by uploading it to the OpenML server.
}
\note{
This function will reset the cache of \code{\link{listOMLDataSets}} on success.
}
\seealso{
Other uploading functions: \code{\link{makeOMLStudy}},
  \code{\link{uploadOMLFlow}}, \code{\link{uploadOMLRun}},
  \code{\link{uploadOMLStudy}}

Other data set-related functions: \code{\link{OMLDataSetDescription}},
  \code{\link{OMLDataSet}},
  \code{\link{convertMlrTaskToOMLDataSet}},
  \code{\link{convertOMLDataSetToMlr}},
  \code{\link{deleteOMLObject}},
  \code{\link{getOMLDataSet}},
  \code{\link{listOMLDataSets}}, \code{\link{tagOMLObject}}
}
\concept{data set-related functions}
\concept{uploading functions}
