% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_image_rscript.R
\name{translation}
\alias{translation}
\title{image translation}
\usage{
translation(image, shift_rows = 0, shift_cols = 0)
}
\arguments{
\item{image}{a matrix, data frame or 3-dimensional array}

\item{shift_rows}{a positive or negative integer specifying the direction that the rows should be shifted}

\item{shift_cols}{a positive or negative integer specifying the direction that the columns should be shifted}
}
\value{
a matrix or 3-dimensional array
}
\description{
shift the position of an image by adding/subtracting a value to/from the X or Y coordinates
}
\details{
If shift_rows is not zero then the image will be sifted row-wise (upsides or downsides depending on the sign). If shift_cols is not zero then 
the image will be sifted column-wise (right or left depending on the sign).
}
\examples{

path = system.file("tmp_images", "1.png", package = "OpenImageR")

image = readImage(path)

res_tr = translation(image, shift_rows = 10, shift_cols = -10)

}

