% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmicsPLS.R
\name{mse}
\alias{mse}
\title{Calculate mean squared difference}
\usage{
mse(x, y = 0, na.rm = FALSE)
}
\arguments{
\item{x}{Numeric vector or matrix.}

\item{y}{Numeric vector or matrix. Defaults to 0.}

\item{na.rm}{Remove NA's?}
}
\value{
The mean of the squared differences elementwise.
}
\description{
Calculate mean squared difference
}
\details{
Is equal to ssq(\code{x-y})/length(c(\code{x})). If \code{x} and \code{y} are of unequal length, the invoked minus-operator will try to make the best out of it by recycling elements of the shorter object (usually you don't want that).
In particular if \code{x} is an N x p matrix and \code{y} an N x 1 vector, y is subtracted from each column of \code{x}, and if \code{y=0} (default) you get the mean of vec(\code{x^2})
}
\examples{
mse(2)
mse(1:10,2:11) == 1
mse(matrix(rnorm(500),100,5),matrix(rnorm(500),100,5))
}
