% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{getEnrichmentsTable}
\alias{getEnrichmentsTable}
\title{Get enrichments table from a study}
\usage{
getEnrichmentsTable(
  study,
  modelID,
  annotationID,
  type = "nominal",
  libraries = NULL
)
}
\arguments{
\item{study}{An OmicNavigator study. Either an object of class \code{onStudy},
or the name of an installed study package.}

\item{modelID}{Filter by modelID}

\item{annotationID}{Filter by annotationID}

\item{type}{Type of p-value: (\code{"nominal"} or \code{"adjusted"})}

\item{libraries}{The directories to search for installed study packages. If
left as \code{NULL} (the default), then
\code{\link[utils]{installed.packages}} will use the result of
\code{\link{.libPaths}}.}
}
\value{
A data frame of enrichments with the following columns:

  \item{termID}{The unique ID for the annotation term}
  \item{description}{The description of the annotation term}
  \item{...}{One column for each of the enrichments}
}
\description{
Get enrichments table from a study
}
