% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Olink_boxplot.R
\name{olink_boxplot}
\alias{olink_boxplot}
\title{Function which plots boxplots of selected variables}
\usage{
olink_boxplot(
  df,
  variable,
  olinkid_list,
  verbose = FALSE,
  number_of_proteins_per_plot = 6,
  ...
)
}
\arguments{
\item{df}{NPX data frame in long format with at least protein name (Assay), OlinkID (unique), UniProt and at least one grouping variable.}

\item{variable}{A character vector or character value indicating which column to use as the x-axis and fill grouping variable.
The first or single value is used as x-axis, the second as fill. Further values in a vector are not plotted.}

\item{olinkid_list}{Character vector indicating which proteins (OlinkIDs) to plot.}

\item{verbose}{Boolean. If the plots are shown as well as returned in the list (default is false).}

\item{number_of_proteins_per_plot}{Number of boxplots to include in the facet plot (default 6).}

\item{...}{coloroption passed to specify color order}
}
\value{
A list of objects of class “ggplot” (the actual ggplot object is entry 1 in the list). Box and whisker plot of NPX (y-axis) by variable (x-axis) for each Assay
}
\description{
Generates faceted boxplots of NPX vs. grouping variable(s) for a given list of proteins (OlinkIDs) using ggplot and ggplot2::geom_boxplot.
}
\examples{
\donttest{

library(dplyr)

anova_results <- olink_anova(npx_data1, variable = "Site")
significant_assays <- anova_results \%>\%
    filter(Threshold == 'Significant') \%>\%
    pull(OlinkID)
olink_boxplot(npx_data1,
              variable = "Site",
              olinkid_list = significant_assays,
              verbose = TRUE,
              number_of_proteins_per_plot = 3)}

}
