% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OddsPlotR.R.R
\name{odds_plot}
\alias{odds_plot}
\title{odds_plot - a function to create Odds Plots}
\usage{
odds_plot(
  x,
  title = NULL,
  subtitle = NULL,
  point_col = "blue",
  error_bar_colour = "black",
  point_size = 0.3,
  error_bar_width = 0.3,
  h_line_color = "black"
)
}
\arguments{
\item{x}{The trained caret GLM logistic regression model}

\item{title}{Title for the Odds Plot}

\item{subtitle}{Subtitle for the Odds Plot}

\item{point_col}{Defaults to blues, but R colour codes can be passed}

\item{error_bar_colour}{the colour of the error bar}

\item{point_size}{the point size of the plot}

\item{error_bar_width}{the width of the displayed error bar}

\item{h_line_color}{the colour of the horizontal line}
}
\value{
A list of the odds returned from logistic regression and a plot showing the odds
}
\description{
This has been created to generate odds plots on the back of results from a generalised linear model.
}
\examples{
#We will use the cancer dataset to build a GLM model to predict cancer status
#this will detail whether the patient has a benign or malignant
library(mlbench)
library(caret)
library(tibble)
library(ggplot2)
library(OddsPlotty)
library(e1071)
library(ggthemes)

#Bring in the data
data("BreastCancer", package = "mlbench")
breast <- BreastCancer[complete.cases(BreastCancer), ]
breast <- breast[, -1]
head(breast, 10)
breast$Class <- factor(breast$Class)
for(i in 1:9) {
breast[, i] <- as.numeric(as.character(breast[, i]))
}

#Train GLM model
glm_model <- train(Class ~ ., data = breast, method = "glm", family = "binomial")

#Visualise the data with OddsPlotty
plotty <- OddsPlotty::odds_plot(glm_model$finalModel,title = "Odds Plot")
plotty$odds_plot

#Extract underlying odds ratios
plotty$odds_data
}
