% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visCPS.R
\name{visCPS}
\alias{visCPS}
\title{CPS Analysis on selecting visualization method.}
\usage{
visCPS(vlab, ref, nEXP = 100)
}
\arguments{
\item{vlab}{-- the coordinates generated by one visualizatoin method.}

\item{ref}{-- the true labels in a vector format, the first cluster is labeled as 1.}

\item{nEXP}{-- number of perturbed reuslts for CPS Analysis.}
}
\value{
a list used for mplot or cplot, in which tight_all is the overall tightness, member is the matrix used for the membership heat map, set is the matrix for the covering point set plot, tight is the vector of cluster-wise tightness, vis is the visualization coordinates, and ref is the reference labels.
}
\description{
Covering Point Set Analysis on the visualization results. Use K-Nearest Neighbor to generate a collection of results for CPS Analysis. The return contains several statistics which can be directly used as input for mplot or cplot.
}
\examples{
# CPS analysis on selection of visualization methods
data(vis_pollen)
c=visCPS(vis_pollen$vis, vis_pollen$ref)
# visualization of the results
mplot(c,2)
cplot(c,2)
}
