% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_party_ODT.R
\name{as.party.ODT}
\alias{as.party.ODT}
\title{\code{ODT} as \code{party}}
\usage{
\method{as.party}{ODT}(obj, data, ...)
}
\arguments{
\item{obj}{An object of class \code{\link{ODT}}.}

\item{data}{Training data of class \code{data.frame} is used to convert the object of class \code{ODT},
and it must be the training data \code{data} in \code{\link{ODT}}.}

\item{...}{Arguments to be passed to methods}
}
\value{
An objects of class \code{party}.
}
\description{
To make \code{ODT} object to objects of class \code{party}.
}
\examples{
data(iris)
tree <- ODT(Species ~ ., data = iris)
tree
plot(tree)
party.tree <- as.party(tree, data = iris)
party.tree
plot(party.tree)

}
\references{
Lee, EK(2017) PPtreeViz: An R Package for Visualizing Projection Pursuit Classification Trees, Journal of Statistical Software.
}
\seealso{
\code{\link{ODT}} \code{\link{party}}
}
\keyword{tree}
