% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setState.R
\name{setState}
\alias{setState}
\title{Set starting State}
\usage{
setState(odenet, state1, state2)
}
\arguments{
\item{odenet}{[\code{ODEnetwork}]\cr
List of class \code{\link{ODEnetwork}}.}

\item{state1}{[\code{numeric(n)}]\cr
Numeric vector of length n (same as in \code{\link{ODEnetwork}}) with position or angle.}

\item{state2}{[\code{numeric(n)}]\cr
Numeric vector of length n (same as in \code{\link{ODEnetwork}}) with velocity or magnitude.}
}
\value{
an extended list of class [\code{\link{ODEnetwork}}].
}
\description{
Sets the starting State for the given \code{\link{ODEnetwork}}.
}
\examples{
masses <- 4:6
dampers <- diag(1:3)
springs <- diag(7:9)
odenet <- ODEnetwork(masses, dampers, springs)
position <- rep(10, 3)
velocity <- rep(0, 3)
odenet <- setState(odenet, position, velocity)
}
