% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metals.R
\name{calc_zinc_availability}
\alias{calc_zinc_availability}
\title{Calculate the availability of the metal Zinc}
\usage{
calc_zinc_availability(B_LU_BRP, B_SOILTYPE_AGR, A_PH_CC, A_ZN_CC)
}
\arguments{
\item{B_LU_BRP}{(numeric) The crop code from the BRP}

\item{B_SOILTYPE_AGR}{(character) The agricultural type of soil}

\item{A_PH_CC}{(numeric) The acidity of the soil, determined in 0.01M CaCl2 (-)}

\item{A_ZN_CC}{The plant available Zn content, extracted with 0.01M CaCl2 (mg / kg)}
}
\value{
The function of the soil to supply zinc A numeric value.
}
\description{
This function calculates the availability of Zn for plant uptake
}
\examples{
calc_zinc_availability(B_LU_BRP = 265, B_SOILTYPE_AGR = 'dekzand',A_PH_CC = 4.5, A_ZN_CC = 3000)
calc_zinc_availability(B_LU_BRP = 265, 'dekzand',4,3500)
calc_zinc_availability(B_LU_BRP = c(1019,265), c('dekzand','rivierklei'),c(4.5,4.8),c(2500,4500))

}
