% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormCombined.R
\name{NormCombined}
\alias{NormCombined}
\title{Normalisation methods based on a combination of methods}
\usage{
NormCombined(featuredata, methods = c("rlsc", "median"),
  savefinaloutput = FALSE, finaloutputname = NULL, ...)
}
\arguments{
\item{featuredata}{featuredata A data frame in the featuredata format. 
This is a dataframe with metabolites in columns and samples in rows.
Unique sample names should be provided as row names.}

\item{methods}{A character vector indicating which two methods should be used in order.}

\item{savefinaloutput}{A logical indicating whether the final normalised data matrix
should be saved as a .csv file.}

\item{finaloutputname}{The name of the final output file if the output has to be saved.}

\item{...}{Inputs for the \code{NormScaling}, \code{NormQcmets}, and \code{NormQcsamples} 
as appropriate.}
}
\value{
The result is an object of class
\code{\link[NormalizeMets:alldata]{alldata}}.
}
\description{
Normalise a metabolomic data matrix using a combination of methods
}
\examples{
 ##Reading the data
 data(Didata)
 NormCombined(featuredata=Didata$featuredata[order(Didata$sampledata$order),],
            sampledata=Didata$sampledata[order(Didata$sampledata$order),],
            methods=c("rlsc", "median"),
            savefinaloutput=FALSE, 
            finaloutputname=NULL)


    
}
\references{
De Livera, Alysha M De, M. Aho-Sysi, Laurent Jacob, 
J. Gagnon-Bartch, Sandra Castillo, J.A. Simpson, and Terence P. Speed. 
2015. Statistical Methods for Handling Unwanted Variation in 
Metabolomics Data. \emph{Analytical Chemistry} 87 (7). American Chemical Society: 
3606-3615.

De Livera, A. M., Dias, D. A., De Souza, D., Rupasinghe, T.,
Pyke, J., Tull, D., Roessner, U., McConville, M., Speed, T. P. (2012a)
Normalising and integrating metabolomics data. \emph{Analytical Chemistry}
84(24): 1076-10776.

De Livera, A.M., Olshansky, M., Speed, T. P. (2013) Statistical analysis of
metabolomics data. \emph{Methods in Molecular Biology} In press.

Gagnon-Bartsch, Johann A., Speed, T. P. (2012) Using control genes to
correct for unwanted variation in microarray data. \emph{Biostatistics}
13(3): 539-552.

Redestig, H., Fukushima, A., Stenlund, H., Moritz, T., Arita, M., Saito, K.,
Kusano, M. (2009) Compensation for systematic cross-contribution improves
normalization of mass spectrometry based metabolomics data. \emph{Analytical
Chemistry} 81(19): 7974-7980.

Sysi-Aho, M., Katajamaa, M., Yetukuri, L., Oresic, M. (2007) Normalization
method for metabolomics data using optimal selection of multiple internal
standards. \emph{BMC Bioinformatics} 8(1): 93.

Dunn,W.B., Broadhurst,D., Begley,P., Zelena,E., Francis-McIntyre,S., Anderson,N., Brown,M., 
Knowles,J.D., Halsall,A., Haselden,J.N. et al. (2011) Procedures for 
large-scale metabolic profiling of serum and plasma using gas chromatography and 
liquid chromatography coupled to mass spectrometry. Nat. Protoc., 6, 1060-1083
}
\author{
Alysha M De Livera, Gavriel Olshansky
}
