% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NRDD.R
\name{NRDD}
\alias{NRDD}
\title{Nonlinear RDD estimator}
\usage{
NRDD(
  df,
  b1 = 2 * nrow(df)^{
     -1/5
 },
  b2 = 2 * nrow(df)^{
     -1/5
 },
  b3 = 2 * nrow(df)^{
     -1/5
 },
  t_tilde = stats::median(df[, 2]),
  e_space,
  Nonseparable = TRUE
)
}
\arguments{
\item{df}{Data frame whose columns are outcome Y, treatment Treat, and running variable R, respectively.}

\item{b1}{Bandwidth for the local linear estimation of the conditional distribution of Y given T,R. Default is n^(-1/5), where n is the sample size.}

\item{b2}{Bandwidth for the smoothing of the indicator function 1(Y <= y).}

\item{b3}{Bandwidth for the first-step conditional quantile estimation of T given R.}

\item{t_tilde}{Normalization constant in the structural function.}

\item{e_space}{The space of epsilon on which the numerical integration is conducted.}

\item{Nonseparable}{Whether the structural function should be estimated as a separable or nonseparable function of the treatment. The default is TRUE.}
}
\value{
The estimated parameters in the structural function.
}
\description{
Semiparametric estimation of the possibly nonlinear and nonseparable structural function in regression discontinuity designs with a continuous treatment variable
}
\examples{
n <- 20
set.seed(123)
Treat <- runif(n)
R <- runif(n)-0.5
epsilon <- Treat^2 + R
Y <- Treat + R + epsilon
df <- data.frame(Y=Y,Treat=Treat,R=R)
NRDD(df,e_space = seq(0,1,by=0.5),Nonseparable=FALSE)

\donttest{
n <- 500
set.seed(123)
data <- nrddgp(n)
NRDD(data,e_space = seq(-10,10,by=1))
}
}
