% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds_basic.R
\name{ds_basic}
\alias{ds_basic}
\title{A basic datasource (DS)}
\usage{
ds_basic(
  binned_data,
  labels,
  num_cv_splits,
  use_count_data = FALSE,
  num_label_repeats_per_cv_split = 1,
  label_levels = NULL,
  num_resample_sites = NULL,
  site_IDs_to_use = NULL,
  site_IDs_to_exclude = NULL,
  randomly_shuffled_labels = FALSE,
  create_simultaneous_populations = 0
)
}
\arguments{
\item{binned_data}{A string that list a path to a file that has data in
binned format, or a data frame of binned_data that is in binned format.}

\item{labels}{A string specifying the name of the labels that should
be decoded. This label must be one of the columns in the binned data that
starts with 'label.'. For example, if there was a column name in a binned
data file called labels.stimulus_ID that you wanted to decode, then you
would set this argument to be "stimulus_ID".}

\item{num_cv_splits}{A number specifying how many cross-validation splits
should be used.}

\item{use_count_data}{If the binned data is neural spike counts, then setting
use_count_data = TRUE will convert the data into spike counts. This is
useful for classifiers that work on spike count data, e.g., the
poisson_naive_bayes_CL.}

\item{num_label_repeats_per_cv_split}{A number specifying how many times each
label should be repeated in each cross-validation split.}

\item{label_levels}{A vector of strings specifying specific label
levels that should be used. If this is set to NULL then all label levels
available will be used.}

\item{num_resample_sites}{The number of sites that should be randomly
selected when constructing training and test vectors. This number needs to
be less than or equal to the number of sites available that have
num_cv_splits * num_label_repeats_per_cv_split repeats.}

\item{site_IDs_to_use}{A vector of integers specifying which sites should be
used. If this is NULL (default value), then all sites that have
num_cv_splits * num_label_repeats_per_cv_split repeats will be used, and
a message about how many sites are used will be displayed.}

\item{site_IDs_to_exclude}{A vector of integers specifying which sites should
be excluded.}

\item{randomly_shuffled_labels}{A Boolean specifying whether the labels
should be shuffled prior to running an analysis (i.e., prior to the first
call to the the get_data() method). This is used when one wants to create a
null distribution for comparing when decoding results are above chance.}

\item{create_simultaneous_populations}{If the data from all sites
was recorded simultaneously, then setting this variable to 1 will cause the
get_data() function to return simultaneous populations rather than
pseudo-populations.}
}
\value{
This constructor creates an NDR datasource object with the class
\code{ds_basic}. Like all NDR datasource objects, this datasource will be used
by the cross-validator to generate training and test data sets.
}
\description{
The standard datasource used to get training and test splits of data.
}
\details{
This 'basic' datasource is the datasource that will most commonly be used for
most analyses. It can generate training and tests sets for data that has been
recorded simultaneously or pseudo-populations for data that was not recorded
simultaneously.

Like all datasources, this datasource takes binned format data and has a
\code{get_data()} method that is never explicitly called by the user of the
package, but rather it is called internally by a cross-validation object to
get training and testing splits of data that can be passed to a classifier.
}
\examples{
# A typical example of creating a datasource to be passed cross-validation object
data_file <- system.file("extdata/ZD_150bins_50sampled.Rda", package = "NeuroDecodeR")
ds <- ds_basic(data_file, "stimulus_ID", 18)

# If one has many repeats of each label, decoding can be faster if one
# uses fewer CV splits and repeats each label multiple times in each split.
ds <- ds_basic(data_file, "stimulus_ID", 6,
  num_label_repeats_per_cv_split = 3
)

# One can specify a subset of labels levels to be used in decoding. Here
#  we just do a three-way decoding analysis between "car", "hand" and "kiwi".
ds <- ds_basic(data_file, "stimulus_ID", 18,
  label_levels = c("car", "hand", "kiwi")
)

# One never explicitly calls the get_data() function, but rather this is
# called by the cross-validator. However, to illustrate what this function
# does, we can call it explicitly here to get training and test data:
all_cv_data <- get_data(ds)
names(all_cv_data)

}
\seealso{
Other datasource: 
\code{\link{ds_generalization}()}
}
\concept{datasource}
