% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_data_functions.R
\name{convert_matlab_raster_data}
\alias{convert_matlab_raster_data}
\title{Convert raster data in MATLAB to R}
\usage{
convert_matlab_raster_data(
  matlab_raster_dir_name,
  r_raster_dir_name = NULL,
  save_file_type = "rda",
  sampling_interval_width = 1,
  zero_time_bin = NULL,
  files_contain = "",
  add_sequential_trial_numbers = FALSE
)
}
\arguments{
\item{matlab_raster_dir_name}{A character string specifying the path to a
directory that contains raster data in MATLAB .mat files.}

\item{r_raster_dir_name}{A character string specifying the path to a
directory where the converted raster data in R files will be saved. If
this is not specified then the saved directory will have the same name as
the matlab directory with _rda appended to the end of the directory name.}

\item{save_file_type}{A character string specifying the format that the
raster data should be saved as. This must be set to a string that is either
"rda", "rds", or "csv", and files will be saved to the corresponding
format.}

\item{sampling_interval_width}{A number specifying how successive time bins
will be labeled The default value of 1 means that points will be labeled as
successive integers; i.e., time.1_2, time.2_3, etc. If this value was set
to a larger number, then time points will be specified at the given
sampling width. From example, if sampling_width is set to 10, then the time
labels would be time.1_10, time.10_20, etc. This is useful if the data is
sampled at a particular rate (e.g., if the data is sampled at 500Hz, one
might want to use sampling_interval_width = 2, so that the times listed on
the raster column names are in milliseconds).}

\item{zero_time_bin}{A number specifying the time bin that should be marked
as time 0. The default (NULL value) is to use the first bin as time 1.}

\item{files_contain}{A string specifying that only a subset of the MATLAB
raster data should be converted based on .mat files that contain this
string.}

\item{add_sequential_trial_numbers}{A Boolean specifying one should add a
variable to the data called 'trial_number' that has sequential trial. These
trials numbers are needed for data that was recorded simultaneously so that
trials can be aligned across different sites.}
}
\value{
Returns a string with the name of the directory that the .rda raster
files have been saved to.
}
\description{
If one already has raster data created in MATLAB (.mat files), this function
can be used to convert it to an R format (.rda files) that can be used with
the NDR.
}
\examples{

\donttest{

matlab_raster_dir_name <- file.path(
  system.file("extdata", package = "NeuroDecodeR"),
  "Zhang_Desimone_7object_raster_data_small_mat"
)

# create temporary directory to hold converted data
r_raster_dir_name <- tempdir()
r_raster_dir_name <- convert_matlab_raster_data(matlab_raster_dir_name,
  r_raster_dir_name,
  files_contain = "bp1001spk"
)

}

}
