% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SensMatPlot.R
\name{SensMatPlot}
\alias{SensMatPlot}
\title{Plot sensitivities of a neural network model}
\usage{
SensMatPlot(
  hess,
  sens = NULL,
  output = 1,
  metric = c("mean", "std", "meanSensSQ"),
  senstype = c("matrix", "interactions"),
  ...
)
}
\arguments{
\item{hess}{\code{HessMLP} object created by \code{\link[NeuralSens]{HessianMLP}}.}

\item{sens}{\code{SensMLP} object created by \code{\link[NeuralSens]{SensAnalysisMLP}}.}

\item{output}{\code{numeric} or {character} specifying the output neuron or output name to be plotted.
By default is the first output (\code{output = 1}).}

\item{metric}{\code{character} specifying the metric to be plotted. It can be "mean",
"std" or "meanSensSQ".}

\item{senstype}{\code{character} specifying the type of plot to be plotted. It can be "matrix" or
"interactions". If type = "matrix", only the second derivatives are plotted. If type = "interactions"
the main diagonal are the first derivatives respect each input variable.}

\item{...}{further argument passed similar to \code{ggcorrplot} arguments.}
}
\value{
a list of \code{\link[ggplot2]{ggplot}}s, one for each output neuron.
}
\description{
Function to plot the sensitivities created by \code{\link[NeuralSens]{HessianMLP}}.
}
\details{
Most of the code of this function is based on
\code{ggcorrplot()} function from package \code{ggcorrplot}. However, due to the
inhability of changing the limits of the color scale, it keeps giving a warning
if that function is used and the color scale overwritten.
}
\examples{
## Load data -------------------------------------------------------------------
data("DAILY_DEMAND_TR")
fdata <- DAILY_DEMAND_TR
## Parameters of the NNET ------------------------------------------------------
hidden_neurons <- 5
iters <- 100
decay <- 0.1

################################################################################
#########################  REGRESSION NNET #####################################
################################################################################
## Regression dataframe --------------------------------------------------------
# Scale the data
fdata.Reg.tr <- fdata[,2:ncol(fdata)]
fdata.Reg.tr[,3] <- fdata.Reg.tr[,3]/10
fdata.Reg.tr[,1] <- fdata.Reg.tr[,1]/1000

# Normalize the data for some models
preProc <- caret::preProcess(fdata.Reg.tr, method = c("center","scale"))
nntrData <- predict(preProc, fdata.Reg.tr)

#' ## TRAIN nnet NNET --------------------------------------------------------
# Create a formula to train NNET
form <- paste(names(fdata.Reg.tr)[2:ncol(fdata.Reg.tr)], collapse = " + ")
form <- formula(paste(names(fdata.Reg.tr)[1], form, sep = " ~ "))

set.seed(150)
nnetmod <- nnet::nnet(form,
                      data = nntrData,
                      linear.output = TRUE,
                      size = hidden_neurons,
                      decay = decay,
                      maxit = iters)
# Try HessianMLP
H <- NeuralSens::HessianMLP(nnetmod, trData = nntrData, plot = FALSE)
NeuralSens::SensMatPlot(H)
S <- NeuralSens::SensAnalysisMLP(nnetmod, trData = nntrData, plot = FALSE)
NeuralSens::SensMatPlot(H, S, senstype = "interactions")
}
