% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotestimates}
\alias{plotestimates}
\title{Plot estimates vs. true values.}
\usage{
plotestimates(
  df,
  estimator_labels = ggplot2::waiver(),
  parameter_labels = NULL
)
}
\arguments{
\item{df}{a long form data frame containing fields \code{estimator}, \code{parameter}, \code{estimate}, and \code{truth}.}

\item{estimator_labels}{a named vector containing estimator labels.}

\item{parameter_labels}{a named vector containing parameter labels.}
}
\value{
a \code{'ggplot'} of the estimates for each parameter against the true value.
}
\description{
Plot estimates vs. true values.
}
\examples{
\dontrun{
K <- 50
df <- data.frame(
  estimator = c("Estimator 1", "Estimator 2"), 
  parameter = rep(c("mu", "sigma"), each = K),
  truth = 1:(2*K), 
  estimate = 1:(2*K) + rnorm(4*K)
)
estimator_labels <- c("Estimator 1" = expression(hat(theta)[1]("·")),
                      "Estimator 2" = expression(hat(theta)[2]("·")))
parameter_labels <- c("mu" = expression(mu), "sigma" = expression(sigma))

plotestimates(df,  parameter_labels = parameter_labels, estimator_labels)}
}
