% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow.frac.R
\name{flow.frac}
\alias{flow.frac}
\title{Flow Fraction}
\usage{
flow.frac(A, nodes)
}
\arguments{
\item{A}{An adjacency matrix}

\item{nodes}{A subset of nodes in the network}
}
\value{
Returns a flow fraction value
}
\description{
Computes \code{\link[NetworkToolbox]{eigenvector}} centrality over nodes in a subset of nodes
in the network. This measure generalizes across any subset of nodes and
is not specific to communities
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

nodes <- seq(1,48,2)

result <- flow.frac(A, nodes)

}
\references{
Giscard, P. L., & Wilson, R. C. (2018).
A centrality measure for cycles and subgraphs II.
\emph{Applied Network Science}, \emph{3}, 9.
doi: \href{https://doi.org/10.1007/s41109-018-0064-5}{10.1007/s41109-018-0064-5}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
