% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centlist.R
\name{centlist}
\alias{centlist}
\title{List of Centrality Measures}
\usage{
centlist(A, weighted = TRUE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted?
Defaults to TRUE.
Set to FALSE for unweighted list of centrality measures}
}
\value{
Returns a list containing:

\item{BC}{Betweenness centrality}

\item{LC}{Closeness centrality}

\item{k}{Degree (weighted = FALSE)}

\item{Str}{Strength (weighted = TRUE)}

\item{EC}{Eigenvector centrality}

\item{lev}{Leverage centrality}

\item{HC}{Hybrid centrality (weighted = TRUE)}
}
\description{
Computes centrality measures of the network
}
\examples{
A <- TMFG(neoOpen)$A

#Weighted
centW <- centlist(A, weighted = TRUE)

#Unweighted
centU <- centlist(A, weighted = FALSE)

}
\references{
Pozzi, F., Di Matteo, T., & Aste, T. (2013).
Spread of risk across financial markets: Better to invest in the peripheries. 
\emph{Scientific Reports}, \emph{3}(1655), 1-7.
doi: \href{https://doi.org/10.1038/srep01665}{10.1038/srep01665}

Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}, 1059-1069.
doi: \href{https://doi.org/10.1016/j.neuroimage.2009.10.003}{10.1016/j.neuroimage.2009.10.003}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
