% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{bootgenPlot}
\alias{bootgenPlot}
\title{Bootstrapped Network Generalization Plots}
\usage{
bootgenPlot(object, bootmat = FALSE)
}
\arguments{
\item{object}{An output from the \emph{bootgen} function}

\item{bootmat}{Should the bootstrap generalization matrix be included?
Defaults to FALSE.
Set to TRUE to plot the original and bootmat networks' reliablities}
}
\value{
Returns the following plots:
a reliability matrix for the original network
("Original Network Correlation Reliabilities"
upper triangle = network reliabilites from the filtered network,
lower triangle = full, unfiltered matrix reliablities),
a plot of retained correlations on their reliability ("Original Network Correlation Strength on Reliability"),
If bootmat is set to TRUE, then also 
a reliability matrix for the bootgen network
("bootgen Network Correlation Reliabilities"
upper triangle = network reliabilites from the bootgen filtered network,
lower triangle = full, unfiltered matrix reliablities),
a plot of retained correlations on their reliability ("bootgen Network Correlation Strength on Reliability"),
a frequency of the reliability of edges in both the original and bootgen network
}
\description{
Generates reliability plots from the \emph{bootgen} function
}
\examples{
\dontrun{
bootTMFG <- bootgen(neoOpen)

bootPlot <- bootPlot(bootTMFG)
}
}
\references{
Wei, T. & Simko, V.(2017).
R package "corrplot": Visualization of a correlation matrix (Version 0.84).
Available from \url{https://github.com/taiyun/corrplot}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
