% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_dsd.R
\name{nd.dsd}
\alias{nd.dsd}
\title{Discrete Spectral Distance}
\usage{
nd.dsd(A, out.dist = TRUE, type = c("Adj", "Lap", "SLap", "NLap"))
}
\arguments{
\item{A}{a list of length \eqn{N} containing \eqn{(M\times M)} adjacency matrices.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{type}{type of target structure. One of \code{"Adj","Lap","SLap","NLap"} as defined above.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
\item{spectra}{an \eqn{(N\times M-1)} matrix where each row is top-\eqn{M-1} vibrational spectra.}
}
}
\description{
Discrete Spectral Distance (DSD) is defined as the Euclidean distance between
the spectra of various matrices, such as adjacency matrix \eqn{A}(\code{"Adj"}),
(unnormalized) Laplacian matrix \eqn{L=D-A}(\code{"Lap"}),
signless Laplacian matrix \eqn{|L|=D+A}(\code{"SLap"}), or
normalized Laplacian matrix \eqn{\tilde{L}=D^{-1/2}LD^{-1/2}}.
}
\examples{
## load example data and extract only a few
data(graph20)
gr.small = graph20[c(1:5,11:15)]

## Compute Distance Matrix and Visualize
\dontrun{
output <- nd.dsd(gr.small, out.dist=FALSE)
opar   <- par(pty="s")
image(output$D[,10:1], main="two group case", axes=FALSE, col=gray(0:32/32))
par(opar)
}

}
\references{
\insertRef{wilson_study_2008}{NetworkDistance}
}
