% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pareto.R
\name{ParetoCappedMean}
\alias{ParetoCappedMean}
\title{Pareto capped mean}
\usage{
ParetoCappedMean(cap, scale, shape)
}
\arguments{
\item{cap}{A positive real number -  the claim severity cap.}

\item{scale}{A positive real number - the scale parameter of the Claim Severity's Pareto distribution.}

\item{shape}{A positive real number - the shape parameter of the Claim Severity's Pareto distribution.}
}
\value{
The mean of the claim severity capped at \code{cap} with a Pareto distribution with parameters \code{scale} and \code{shape}.
}
\description{
Pareto capped mean
}
\examples{
ParetoCappedMean(600,200,1.2)
ParetoCappedMean(800,100,1)
ParetoCappedMean(1000,500,0.8)
}
