% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{ptn-data}
\alias{ptn-data}
\alias{ptnAth}
\alias{ptnGoe}
\title{Public transportation network datasets from LinTim software (Integrated Optimization in Public Transportation)}
\source{
Public transportation network datasets are extracted from LinTim software (Integrated Optimization in Public Transportation; \url{https://lintim.net/}). Special thanks to Anita Schoebel for making the data available.

The Athens Metro data was collected by Konstantinos Gkoumas.

The Goettingen bus network data was collected by Barbara Michalski.
}
\description{
Public transportation network datasets from LinTim software (Integrated Optimization in Public Transportation)

\code{ptnAth} The data of the Athens Metro, consisting of 51 nodes and 52 edges. 
\itemize{
\item Vertex attributes: station name, additonal station info. 
\item Edge attributes: track length (in meter), minimal and maximal time required to pass the track (in minutes).
}

\code{ptnGoe} The data of the Goettingen bus network, consisting of 257 nodes and 548 edges. \itemize{
\item Vertex attributes: station name. 
\item Edge attributes:  track length (in meter), minimal and maximal time required to pass the track (in minutes).
}
}
\examples{
# Athens metro system 
data(ptnAth)
plot_ptn(ptnAth)

# Goettingen bus system 
data(ptnGoe)
plot_ptn(ptnGoe)

}
\seealso{
\code{\link{delay-data}}
}
\author{
Juliane Manitz and Jonas Harbering
}
\keyword{data}
