% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/origin_methods.r
\name{origin_multiple}
\alias{origin_multiple}
\title{Multiple origin estimation using community partitioning}
\usage{
origin_multiple(
  events,
  type = c("edm", "backtracking", "centrality"),
  graph,
  no = 2,
  distance,
  fast = TRUE,
  ...
)
}
\arguments{
\item{events}{numeric vector of event counts at specific time point}

\item{type}{character specifying the method, \code{'edm'}, \code{'backtracking'} and \code{'centrality'} are available.}

\item{graph}{igraph object specifying the underlying network graph}

\item{no}{numeric specifying the number of supposed origins}

\item{distance}{numeric matrix specifying the distance matrix}

\item{fast}{logical specifying community partitioning algorithm, default is \code{'TRUE'} that uses \code{\link{fastgreedy.community}}, \code{'FALSE'} refers to \code{\link{leading.eigenvector.community}}}

\item{...}{parameters to be passed to origin methods \code{\link{origin_edm}}, \code{\link{origin_backtracking}} or \code{\link{origin_centrality}}}
}
\value{
\code{origin_multiple} returns an list object with objects of class \code{\link{origin}} of length \code{no}
}
\description{
Multiple origin estimation using community partitioning
}
\examples{
data(ptnAth)
# backtracking
origin_multiple(events=delayAth[10,-c(1:2)], type='backtracking', graph=ptnAth, no=2)
# edm
athnet <- igraph::as_adjacency_matrix(ptnAth, sparse=FALSE)
p <- athnet/rowSums(athnet)
eff <- eff_dist(p)
origin_multiple(events=delayAth[10,-c(1:2)], type='edm', graph=ptnAth, no=2, distance=eff)

}
\references{
Zang, W., Zhang, P., Zhou, C. and Guo, L. (2014) Discovering Multiple Diffusion Source Nodes in Social Networks. Procedia Computer Science, 29, 443-452. <DOI: 10.1016/j.procs.2014.05.040>
}
\seealso{
Other origin-est: 
\code{\link{origin}()}
}
\concept{origin-est}
