% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{die}
\alias{die}
\alias{die,agentMatrix,numeric-method}
\title{Kill \code{turtles}}
\usage{
die(turtles, who)

\S4method{die}{agentMatrix,numeric}(turtles, who)
}
\arguments{
\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{who}{Integer. Vector of the \code{who} numbers for the selected \code{turtles}.}
}
\value{
\code{AgentMatrix} representing the \code{turtles} with the selected
        ones removed.
}
\description{
Kill selected \code{turtles}.
}
\details{
The \code{who} numbers of the remaining \code{turtles} are unchanged.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
t1 <- createTurtles(n = 10, world = w1)
NLcount(t1)
t1 <- die(turtles = t1, who = c(2, 3, 4))
NLcount(t1)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#die}
}
\author{
Sarah Bauduin
}
