% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.agentMatrix}
\alias{plot.agentMatrix}
\alias{plot.worldMatrix}
\alias{plot.worldArray}
\alias{points.agentMatrix}
\title{Basic plot methods for \code{agentMatrix}, \code{worldMatrix}, \code{worldArray}}
\usage{
\method{plot}{agentMatrix}(x, ...)

\method{plot}{worldMatrix}(x, ...)

\method{plot}{worldArray}(x, ...)

\method{points}{agentMatrix}(x, ...)
}
\arguments{
\item{x}{an \code{agentMatrix}, \code{worldMatrix} or \code{worldArray} object}

\item{...}{arguments passed to plot methods for matrix (\code{agentMatrix}) or \code{raster} (\code{world*})}
}
\description{
These pass to plot, as a matrix of points (\code{agentMatrix}), as a \code{raster} (\code{worldMatrix}),
or a \code{rasterStack} (\code{worldArray}).
They can be modified.
}
\examples{
# agentMatrix
 newAgent <- new("agentMatrix",
   coords = cbind(pxcor = c(1, 2, 5), pycor = c(3, 4, 6)),
   char = letters[c(1, 2, 6)],
   nums2 = c(4.5, 2.6, 2343),
   char2 = LETTERS[c(4, 24, 3)],
   nums = 5:7)
 plot(newAgent)

## worldMatrix
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9, data = 1:100)
plot(w1)

## worldArray
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4, data = 1:25)
w2 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4, data = 25:1)
w3 <- stackWorlds(w1, w2)
plot(w3)

# agentMatrix
 newAgent <- new("agentMatrix",
   coords = cbind(pxcor = c(1, 2, 5), pycor = c(3, 4, 6)),
   char = letters[c(1, 2, 6)],
   nums2 = c(4.5, 2.6, 2343),
   char2 = LETTERS[c(4, 24, 3)],
   nums = 5:7)
 points(newAgent)
}
