% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentMatrix-Class-methods.R
\docType{methods}
\name{agentMatrix}
\alias{agentMatrix}
\alias{agentMatrix,matrix-method}
\alias{agentMatrix,missing-method}
\title{Create a new \code{agentMatrix} object}
\usage{
agentMatrix(..., coords)

\S4method{agentMatrix}{matrix}(..., coords)

\S4method{agentMatrix}{missing}(..., coords)
}
\arguments{
\item{...}{Vectors, a data.frame, or a matrix of extra columns to add to the coordinates,
or a \code{SpatialPointsDataFrame}.}

\item{coords}{A matrix with 2 columns representing \code{x} and \code{y} coordinates}
}
\description{
This is a fast alternative to the \code{SpatialPointsDataFrame}. It is meant to replace
that functionality, though there are not as many methods (yet). The object is primarily
a numeric matrix. Any character column passed to ... will be converted to a numeric,
using \code{as.factor} internally, and stored as a numeric. Methods using this class
will automatically convert character queries to the correct numeric alternative.
}
\examples{
newAgent <- agentMatrix(
      coords = cbind(pxcor = c(1, 2, 5), pycor = c(3, 4, 6)),
      char = letters[c(1, 2, 6)],
      nums2 = c(4.5, 2.6, 2343),
      char2 = LETTERS[c(4, 24, 3)],
      nums = 5:7)

w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4,
                          data = runif(25))
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))


}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#clear-turtles}
}
\author{
Eliot McIntire
}
