% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{turtlesAt}
\alias{turtlesAt}
\alias{turtlesAt,worldNLR,agentMatrix,matrix,numeric,numeric,missing-method}
\alias{turtlesAt,worldNLR,agentMatrix,matrix,numeric,numeric,character-method}
\title{\code{Turtles} at}
\usage{
turtlesAt(world, turtles, agents, dx, dy, breed, torus = FALSE)

\S4method{turtlesAt}{worldNLR,agentMatrix,matrix,numeric,numeric,missing}(world, turtles, agents, dx, dy, torus)

\S4method{turtlesAt}{worldNLR,agentMatrix,matrix,numeric,numeric,character}(world, turtles, agents, dx, dy, breed, torus = FALSE)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
column \code{pycor} representing the \code{patches} coordinates, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{          `AgentMatrix` object representing the moving `agents`.
}\if{html}{\out{</div>}}}

\item{dx}{Numeric. Vector of distances to the east (right) from the \code{agents}.
If \code{dx} is negative, the distance to the west (left) is computed.
\code{dx} must be of length 1 or of the same length as number of \code{patches}
or \code{turtles} in \code{agents}.}

\item{dy}{Numeric. Vector of distances to the north (up) from the \code{agents}.
If \code{dy} is negative, the distance to the south is computed (down).
\code{dy} must be of length 1 or of the same length as number of \code{patches}
or \code{turtles} in \code{agents}.}

\item{breed}{Characters. Vector of \code{breed} names for the selected \code{turtles}.
If missing, there is no distinction based upon \code{breed}.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}
}
\value{
\code{AgentMatrix} representing the individuals among \code{turtles}
of any of the given \code{breed}, if specified,
which are located on the \code{patches} at \verb{(dx, dy)} distances of the
\code{agents}.
}
\description{
Report the individuals among \code{turtles} that are located on the \code{patches} at
\verb{(dx, dy)} distances of the \code{agents}.
}
\details{
If the \code{patch} at distance \verb{(dx, dy)}
of an \code{agent} is outside of the \code{world}'s extent and \code{torus = FALSE},
no \code{turtle} is returned;
if \code{torus = TRUE}, the \code{turtle} located on the \code{patch} whose coordinates
are defined from the wrapped \code{world} is returned.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
t1 <- createTurtles(n = 10, coords = cbind(xcor = 0:9, ycor = 0:9),
                    breed = c(rep("sheep", 5), rep("wolf", 5)))
t2 <- turtlesAt(world = w1, turtles = t1, agents = turtle(t1, who = 0),
                dx = 1, dy = 1)
t3 <- turtlesAt(world = w1, turtles = t1,
                agents = patch(w1, c(3,4,5), c(3,4,5)), dx = 1, dy = 1,
                breed = "sheep")


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#turtles-at}

\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#at-points}
}
\author{
Sarah Bauduin
}
