% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{moveTo}
\alias{moveTo}
\alias{moveTo,agentMatrix,matrix-method}
\title{Move to}
\usage{
moveTo(turtles, agents)

\S4method{moveTo}{agentMatrix,matrix}(turtles, agents)
}
\arguments{
\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
column \code{pycor} representing the \code{patches} coordinates, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{          `AgentMatrix` object representing the moving `agents`.
}\if{html}{\out{</div>}}}
}
\value{
\code{AgentMatrix} representing the \code{turtles} with updated coordinates
and updated data for their previous coordinates \code{prevX} and \code{prevY}.
}
\description{
Move the \code{turtles} to the \code{agents}' locations.
}
\details{
The number of \code{agents} must be equal to 1 or to
length \code{turtles}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     The `turtle`'s `headings` are not affected with this function.

     If a `turtle` is moving to a `patch` location, it will be located at
     the `patch` center.
}\if{html}{\out{</div>}}
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9,
                          data = runif(100))
t1 <- createTurtles(n = 5, coords = randomXYcor(w1, n = 5))
plot(w1)
points(t1, col = "black", pch = 16)

t1 <- moveTo(turtles = t1, agents = turtle(t1, who = 0))
points(t1, col = "red", pch = 16)

t1 <- moveTo(turtles = t1, agents = patch(w1, 9, 9))
points(t1, col = "blue", pch = 16)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#move-to}
}
\author{
Sarah Bauduin
}
