% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\name{minNof}
\alias{minNof}
\alias{minNof,matrix,numeric,worldMatrix,missing-method}
\alias{minNof,matrix,numeric,worldArray,character-method}
\alias{minNof,agentMatrix,numeric,missing,character-method}
\title{\code{N} \code{agents} with minimum}
\usage{
minNof(agents, n, world, var)

\S4method{minNof}{matrix,numeric,worldMatrix,missing}(agents, n, world)

\S4method{minNof}{matrix,numeric,worldArray,character}(agents, n, world, var)

\S4method{minNof}{agentMatrix,numeric,missing,character}(agents, n, var)
}
\arguments{
\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
column \code{pycor} representing the \code{patches} coordinates, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{          `AgentMatrix` object representing the moving `agents`.
}\if{html}{\out{</div>}}}

\item{n}{Integer.}

\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{var}{Character. The name of the selected \code{agents} variable.
If \code{agents} are \code{patches} and the \code{world} is a
\code{worldMatrix} object, \code{var} must not be provided. If
\code{agents} are \code{patches} and the \code{world} is a \code{worldArray}
object, \code{var} is the name of the layer to use to define the \code{patches}
values. If \code{agents} are \code{turtles}, \code{var} is one of
the \code{turtles}' variable and can be equal to \code{xcor},
\code{ycor}, any of the variables created when \code{turtles} were created,
as well as any variable created using \code{turtlesOwn()}.}
}
\value{
Matrix (\code{ncol} = 2, \code{nrow} = \code{n}) with the first column \code{pxcor} and
the second column \code{pycor} representing the coordinates of the \code{n}
\code{patches} among the \code{agents} which have their variable values among
the minimum values among the
\code{agents}, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{    `AgentMatrix` of length `n` representing the `turtles` among the
    `agents` which
    have their `var` values among the minimum values among the `agents`.
}\if{html}{\out{</div>}}
}
\description{
Report the \code{n} \code{patches} or \code{turtles} among \code{agents} which have their variable
among the minimum values.
}
\details{
\code{world} must not be provided if \code{agents} are \code{turtles}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     If there is a tie that would make the number of returned `patches` or `turtles` larger
     than `n`, it is broken randomly.
}\if{html}{\out{</div>}}
}
\examples{
# Patches
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4,
                  data = sample(1:10, size = 25, replace = TRUE))
plot(w1)
p1 <- minNof(agents = patches(w1), n = 6, world = w1)

# Turtles
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10),
                    heading = sample(1:5, size = 10, replace= TRUE))
t2 <- minNof(agents = t1, n = 5, var = "heading")


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#min-n-of}
}
\author{
Sarah Bauduin
}
