% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{fd}
\alias{fd}
\alias{fd,agentMatrix,numeric-method}
\title{Move forward}
\usage{
fd(turtles, dist, world, torus = FALSE, out = TRUE)

\S4method{fd}{agentMatrix,numeric}(turtles, dist, world, torus = FALSE, out = TRUE)
}
\arguments{
\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{dist}{Numeric. Vector of distances to move. Must
be of length 1 or of length \code{turtles}.}

\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}

\item{out}{Logical. Determine if a \code{turtle} should move when
\code{torus = FALSE} and its ending position will be outside of
the \code{world}'s extent. Default is \code{out = TRUE}.}
}
\value{
\code{AgentMatrix} representing the \code{turtles} with updated
coordinates and updated data for their previous coordinates \code{prevX}
and \code{prevY}.
}
\description{
Move the \code{turtles} forward with their \code{headings} as directions.
}
\details{
If \code{torus = FALSE} and \code{out = TRUE}, \code{world}
does not need to be provided.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     If a distance to move leads a `turtle` outside of the `world`'s extent
     and `torus = TRUE`, the `turtle` is
     relocated on the other side of the `world`, inside its extent; if
     `torus = FALSE` and `out = TRUE`, the `turtle` moves past the
     `world`'s extent; if `torus = FALSE` and `out = FALSE`, the
     `turtle` does not move at all. In the event that a `turtle` does not move,
     its previous coordinates are still updated with its position before
     running `fd()` (i.e., its current position).

     If a given `dist` value is negative, then the `turtle` moves
     backward.
}\if{html}{\out{</div>}}
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4,
                          data = runif(25))
t1 <- createOTurtles(n = 10, world = w1)
plot(w1)
points(t1, col = of(agents = t1, var = "color"), pch = 16)

t1 <- fd(turtles = t1, dist = 1)
points(t1, col = of(agents = t1, var = "color"), pch = 16)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#forward}

\if{html}{\out{<div class="sourceCode">}}\preformatted{     <https://ccl.northwestern.edu/netlogo/docs/dictionary.html#jump>
}\if{html}{\out{</div>}}
}
\author{
Sarah Bauduin
}
