% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentMatrix-Class-methods.R
\name{extent,worldNLR-method}
\alias{extent,worldNLR-method}
\alias{extent,agentMatrix-method}
\alias{.bboxCoords}
\alias{bbox,agentMatrix-method}
\alias{bbox<-}
\alias{bbox<-,agentMatrix,matrix-method}
\alias{bbox,worldNLR-method}
\title{Bounding box and extent methods for NetLogoR classes}
\usage{
\S4method{extent}{worldNLR}(x, ...)

\S4method{extent}{agentMatrix}(x, ...)

.bboxCoords(coords)

\S4method{bbox}{agentMatrix}(obj)

bbox(obj) <- value

\S4method{bbox}{agentMatrix,matrix}(obj) <- value

\S4method{bbox}{worldNLR}(obj)
}
\arguments{
\item{x}{Raster* or Extent object, a matrix, a bbox, or a vector of four numbers }

\item{...}{Additional arguments. When x is a single number representing 'xmin', you can pass three additional numbers (xmax, ymin, ymax)

When \code{x} is a Raster* object, you can pass four additional arguments to crop the extent: \code{r1, r2, c1, c2}, representing the first and last row and column number }

\item{coords}{xy coordinates for all cells, e.g., produced by \code{raster::coordinates}.}

\item{obj}{ object deriving from class "Spatial", or one of classes: "Line", "Lines", "Polygon" or "Polygons", or ANY, which requires obj to be an array with at least two columns }

\item{value}{2x2 matrix representing the bounding box. See \code{\link[sp:bbox]{sp::bbox()}}.}
}
\value{
\code{bbox} returns a two-column matrix; the first column has the minimum,
the second the maximum values; rows represent the spatial dimensions.
\code{extent} returns an \code{extent} object.

two-column matrix; the first column has the minimum, the second the maximum values;
rows represent the spatial dimensions. See \code{\link[sp:bbox]{sp::bbox()}}.
}
\description{
Same as \code{\link[sp:bbox]{sp::bbox()}} and \code{\link[raster:extent]{raster::extent()}}.
}
