% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worldNLR-classes-methods.R
\name{NLworldIndex}
\alias{NLworldIndex}
\alias{NLworldIndex,worldMatrix,numeric-method}
\title{\code{WorldMatrix} indices from vector indices}
\usage{
NLworldIndex(world, cellNum)

\S4method{NLworldIndex}{worldMatrix,numeric}(world, cellNum)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{cellNum}{Integer. Vector of cells number.}
}
\value{
Numeric. Vector of \code{worldMatrix} indices.
}
\description{
Convert vector indices or \verb{Raster*} cell numbers into \code{worldMatrix} indices.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9, data = 1:100)
w1Ras <- world2raster(w1)
index <- 24
pxpy <- PxcorPycorFromCell(world = w1, cellNum = index)

rasValue <- as.integer(unname(w1Ras[index]))
# Not correct index:
identical(w1[index], rasValue)

# Correct index
identical(w1[NLworldIndex(w1, index)], rasValue)


}
\author{
Eliot McIntire
}
