% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/world-functions.R
\docType{methods}
\name{world2raster}
\alias{world2raster}
\alias{world2raster,worldMatrix-method}
\alias{world2raster,worldArray-method}
\title{Convert a worldMatrix or worldArray object into a Raster* object}
\usage{
world2raster(world)

\S4method{world2raster}{worldMatrix}(world)

\S4method{world2raster}{worldArray}(world)
}
\arguments{
\item{world}{WorldMatrix or worldArray object.}
}
\value{
RasterLayer or RasterStack object depending on the input \code{world}.
        Patches value are retained from the \code{world}.
}
\description{
Convert a worldMatrix object into a RasterLayer object or a
worldArray object into a RasterStack object
}
\details{
The Raster* returned has the same extent and resolution as the \code{world}
         with round coordinates at the center of the cells and coordinates \code{x.5}
         at the edges of the cells.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9, data = runif(100))
r1 <- world2raster(w1)
plot(r1)


}
\author{
Sarah Bauduin
}
