% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\docType{methods}
\name{sprout}
\alias{sprout}
\alias{sprout,numeric,matrix-method}
\title{Sprout new turtles}
\usage{
sprout(n, patches, breed, heading, color, turtles)

\S4method{sprout}{numeric,matrix}(n, patches, breed, heading, color, turtles)
}
\arguments{
\item{n}{Integer. Vector of length 1 or of length the number of \code{patches}.
Number of new turtles
to create on each patch.}

\item{patches}{Matrix (ncol = 2) with the first column "pxcor" and the second
column "pycor" representing the patches coordinates.}

\item{breed}{Character. Vector of "breed" names.
Must be of length 1 or of length the number of \code{patches}.
If missing, breed = "turtle" for all the sprouted turtles.}

\item{heading}{Numeric. Vector of values between 0 and 360.
Must be of length 1 or of length the number of \code{patches}.
If missing, a random heading is assigned to each sprouted turtle.}

\item{color}{Character. Vector of color names.
Must be of length 1, of length the number of \code{patches} or
of length \code{sum(n)}.
If missing, colors are assigned using the function rainbow(n)}

\item{turtles}{AgentMatrix object representing the moving agents.}
}
\value{
AgentMatrix including the new
        sprouted turtles.
}
\description{
Create \code{n} new turtles on specific \code{patches}.
}
\details{
\code{nrow(patches)} must be equal to 1 or to \code{n}.

         If \code{turtles} is provided, the new turtles are added to
         the \code{turtles} when returned. The who numbers of the sprouted turtles
         therefore follow the ones from the \code{turtles}.
         All new sprouted turtles are placed at the end of the agentMatrix object.
         If no \code{turtles}
         is provided, a new agentMatrix is created and the who numbers
         start at 0.

         If \code{turtles} is provided and had additional variables created
         with \code{turtlesOwn()}, \code{NA} is given for these variables
         for the new sprouted turtles.
}
\examples{
t1 <- sprout(patches = cbind(pxcor = 2, pycor = 2), n = 3)
t2 <- sprout(patches = cbind(pxcor = 3, pycor = 3), n = 3, turtles = t1)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#sprout}
}
\author{
Sarah Bauduin
}
