% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netfacs_multiple.R
\name{multiple.netfacs}
\alias{multiple.netfacs}
\title{(Deprecated) Applies the \code{\link{netfacs}} function across multiple
levels of the condition and puts them in a list}
\usage{
multiple.netfacs(
  data,
  condition = NULL,
  duration = NULL,
  ran.trials = 1000,
  control = NULL,
  random.level = NULL,
  combination.size = NULL,
  tail = "upper.tail",
  use_parallel = TRUE,
  n_cores = 2
)
}
\arguments{
\item{data}{A binary matrix with one column per element, and one row per
event, consisting of 1 (element was active during that event) and 0
(element was not active).}

\item{condition}{character vector of same length as 'data' that contains
information on the condition each event belongs to, so probabilities can be
compared across conditions}

\item{duration}{A numeric vector that contains information on the duration of
each event; if NULL, all events are assumed to have equal duration.}

\item{ran.trials}{Number of randomisations that will be performed to find the
null distribution.}

\item{control}{A list of vectors that are used as control variables. During
bootstraps, the ratio of events in each level will be adapted. So, for
example, if in the test distribution, there are three angry participants
for each happy participant, the null distribution will maintain that ratio.}

\item{random.level}{A character vector of the level on which the
randomization should take place. If NULL, the randomization takes place on
the event level (i.e., every row can either be selected or not); if a
vector is provided, the randomization takes place on the levels of that
vector rather than individual events.}

\item{combination.size}{A positive integer, indicating the maximum
combination size of element combinations. Higher numbers will increase
computation time. Default is 2.}

\item{tail}{Either 'upper.tail' (proportion of null probabilities that are
larger than observed probabilities), or 'lower.tail' (proportion of null
probabilities that are smaller than observed probabilities); default is
'upper.tail'.}

\item{use_parallel}{Logical, indicating whether randomization or bootstrap
should be parallelized (default is \code{TRUE})}

\item{n_cores}{Numeric, indicating the number cores to be used for
parallelization. Default is 2.}
}
\value{
Function returns for each level of the condition a list equivalent to
  the results of the netfacs function; can be used to create multiple
  networks and graphs at the same time
}
\description{
This function is deprecated. Please see \code{\link{netfacs_multiple}}
instead
}
