% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copytestdata.R
\name{copytestdata}
\alias{copytestdata}
\title{Function to copy test data to user specified folder}
\source{
The executable and the source code of the model can downloaded from \url{https://github.com/jeroenpullens/NUCOMBog}.
}
\usage{
copytestdata(new_folder,package_folder=NULL)
}
\arguments{
\item{new_folder}{Folder to where the data needs to be copied}

\item{package_folder}{Folder where the R package is installed, if this is not specified during installation leave this empty.}
}
\description{
This function copies the test data from the R package to a user-defined folder. This is necesarry since the model does not read the data from R.

The model needs to be run in a seperate folder and the executable can be downloaded from the provided URL. The executable needs to be copied to the folder where the data is located. The folder structure should be maintained.

If the specified folder does not exist, the function will create it at the user defined loaction. If the packages are installed on default path, then the package_folder argument can be kept empty. If not, the user has to provide the path where the R package is installed.
}
\examples{
\dontrun{
 for Windows:
   copytestdata(new_folder="C:/testdata/",package_folder=NULL)

 for Linux:
   copytestdata(new_folder="~/testdata/",package_folder=NULL)
}
}
\author{
JWM Pullens
}

